/**

The below example tells the mapengine to draw a minimap of the map,
it automatically changes the minimap image when changing maps.

///////////////////////////////////////////////////////////

var g_minimap = CreateSurface(0, 0, CreateColor(0, 0, 0));

SetDefaultMapScript(SCRIPT_ON_ENTER_MAP, "DefaultOnEnterMap()");
function DefaultOnEnterMap() {
  g_minimap = CurrentMapToImage();
}

SetRenderScript("RenderScript()");
function RenderScript() {
  var minimap_x = 5;
  var minimap_y = 5;
  g_minimap.blit(minimap_x, minimap_y);

  // draw a dot on the map where the input person is
  if (IsInputAttached()) {
    var person = GetInputPerson();
    var x = GetPersonX(person) / GetTileWidth();
    var y = GetPersonY(person) / GetTileHeight();
    Point(minimap_x + x, minimap_y + y, CreateColor(200, 100, 50, 128));
  }

}

///////////////////////////////////////////////////////////

*/

/**
  returns the minimap as a surface, unless you want to manipulate the surface
  use CurrentMapToImage()
*/
function CurrentMapToSurface() {
  if (!IsMapEngineRunning())
    return CreateSurface(0, 0, CreateColor(0, 0, 0));
  
  var tile_surfaces = new Array();
  for (var i = 0; i < GetNumTiles(); ++i) {
    var tile_surface = GetTileImage(i).createSurface();
        tile_surface.rescale(1, 1);
    
    tile_surfaces.push(tile_surface);
  }

  var map_width = 0;
  var map_height = 0;
  
  for (var i = 0; i < GetNumLayers(); ++i) {
    map_width  = Math.max(map_width, GetLayerWidth(i));
    map_height = Math.max(map_height, GetLayerHeight(i));
  }

  var map_surface = CreateSurface(map_width, map_height, CreateColor(0, 0, 0, 255));
  
  for (var layer = 0; layer < GetNumLayers(); ++layer) {

    var offset_x = MapToScreenX(layer, 0);
    var offset_y = MapToScreenY(layer, 0);
    var layer_width  = GetLayerWidth(layer);
    var layer_height = GetLayerHeight(layer);

    for (var y = 0; y < layer_height; ++y) {
      for (var x = 0; x < layer_width; ++x) {
        map_surface.blitSurface(tile_surfaces[GetTile(x, y, layer)], x, y);
      }
    }
  }
  
  return map_surface;
}

/**
  returns the minimap as an image
*/
function CurrentMapToImage() {
  return CurrentMapToSurface().createImage();
}
